<?php
require_once("../layouts/members/head.php");

/* =========================
   NEW PAN TO UID API FUNCTION
   ========================= */
function pantoUidfind_run_new($request)
{
    $panNumber = strtoupper($request['panNumber']);
                      $api_key = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

    $url = "https://kycapizone.in/api/v2/pan_advance/pan_to_aadhaar.php"
         . "?api_key={$api_key}&pan_number={$panNumber}";

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    // ✅ SUCCESS ONLY STATUS = 100
    if (isset($res['status']) && (string)$res['status'] === '100') {
        return [
            'status' => '100',
            'uid'    => $res['result']['aadhaar_number'] ?? '',
            'name'   => $res['result']['name'] ?? '',
            'dob'    => $res['result']['dob'] ?? '',
            'gender' => $res['result']['gender'] ?? '',
        ];
    } else {
        return [
            'status' => '101',
            'error'  => $res['message'] ?? 'API Error'
        ];
    }
}

/* =========================
   MAIN PAGE
   ========================= */

if ($user_data['pan2uid_find_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {

if (isset($_POST['submit'])) {

    $order_id    = order_txn_id();
    $amount      = $user_data['pan2uid_find_fee'];
    $old_balance = $user_data['balance'];
    $new_balance = $old_balance - $amount;

    if ($old_balance >= $amount) {

        $panNumber = strtoupper(trim($_POST['panNumber']));

        if (!empty($panNumber)) {

            // 🔥 CALL NEW API
            $response = pantoUidfind_run_new([
                'panNumber' => $panNumber,
                'order_id'  => $order_id
            ]);

            if (isset($response['status']) && $response['status'] == '100') {

                // WALLET UPDATE
                db_update(
                    "members",
                    ["balance" => $new_balance],
                    "user_id='{$user_data['user_id']}'"
                );

                // REPORT ENTRY
                db_insert("reports", [
                    'site_id'        => $site_data['site_id'],
                    'user_id'        => $user_data['user_id'],
                    'username'       => $user_data['username'],
                    'name'           => $user_data['name'],
                    'operator'       => $user_data['usertype'],
                    'parent_id'      => $user_data['parent_id'],
                    'order_id'       => $order_id,
                    'service'        => "PAN UID FIND REQUEST",
                    'type'           => "Debit",
                    'account_number' => $panNumber,
                    'app_type'       => "PAN UID FIND REQUEST",
                    'amount'         => $amount,
                    'main_amount'    => $amount,
                    'old_balance'    => $old_balance,
                    'new_balance'    => $new_balance,
                    'txn_id'         => $order_id,
                    'ref_id'         => $panNumber,
                    'description'    => "Rs.{$amount} Debited for PAN UID FIND",
                    'date_time'      => current_timestamp(),
                    'status'         => "Success"
                ]);

                // PRINT RECORD DATA
                $printData = [
                    'panNumber'=> $panNumber,
                    'name'     => $response['name'],
                    'dob'      => $response['dob'],
                    'gender'   => $response['gender'],
                    'uid'      => $response['uid'],
                    'order_id' => $order_id,
                    'amount'   => $amount,
                    'username' => $user_data['username'],
                ];

                db_insert("printRecords", [
                    'order_id'  => $order_id,
                    'username'  => $user_data['username'],
                    'name'      => $panNumber,
                    'idNumber'  => $panNumber,
                    'service'   => "PanUidFind_Request",
                    'date_time' => current_timestamp(),
                    'printData' => base64_encode(json_encode($printData)),
                    'photo'     => "",
                    'status'    => "Process",
                ]);

                // ADMIN ALERT
                send_sms(
                    $site_data['mobile'],
                    "New PAN UID Find Request\nOrder: {$order_id}\nPAN: {$panNumber}"
                );

                awal_alert_msg("Applied Successfully. Wait for 10 minutes.", 'success');
                redirect('printRecord', 3000);

            } else {
                awal_alert_msg($response['error'], 'error');
            }

        } else {
            awal_alert_msg("Invalid PAN Number!", 'error');
        }
    } else {
        awal_alert_msg("Insufficient Wallet Balance!", 'error');
    }
}
?>

<!-- =========================
     FORM UI (UNCHANGED)
     ========================= -->
<div class="container-xxl flex-grow-1 container-p-y">
<div class="row">
<div class="col-lg-4">
<div class="card border">
<div class="card-header text-white bg-primary">
<h6 class="mb-0"><?= file_name() ?></h6>
</div>

<form method="post">
<div class="card-body">
<div class="mb-3">
<input type="text" class="form-control" id="panNumber"
name="panNumber" maxlength="10"
placeholder="ABCDE1234F" required>
<small id="panError" class="text-danger" style="display:none;">
Invalid PAN Number
</small>
</div>

<div class="d-flex justify-content-between">
<button type="button" class="btn btn-secondary">
₹ <?= $user_data['pan2uid_find_fee']; ?>
</button>

<button type="submit" name="submit"
class="btn btn-primary"
onclick="return confirm('Are you sure?');">
Apply Data
</button>
</div>
</div>
</form>

</div>
</div>
</div>
</div>

<script>
document.getElementById('panNumber').addEventListener('input', function () {
    let v = this.value.toUpperCase().replace(/[^A-Z0-9]/g,'');
    this.value = v;
    const r = /^[A-Z]{5}[0-9]{4}[A-Z]$/;
    document.getElementById('panError').style.display =
        r.test(v) ? 'none' : 'block';
});
</script>

<?php
} else {
require_once("404.php");
}
} else {
awal_alert_msg('You Do Not Have Any Pan Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
